import { useState, useEffect } from 'react'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import course1 from '/images/course-1.jpg'
import course2 from '/images/course-2.jpg'
import course3 from '/images/course-3.jpg'
import course4 from '/images/course-4.jpg'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  
  // Заглушки для изображений
  const images = [
    {
      id: 1,
      src: course1,
      title: 'Курс 1'
    },
    {
      id: 2,
      src: course2,
      title: 'Курс 2'
    },
    {
      id: 3,
      src: course3,
      title: 'Курс 3'
    },
    {
      id: 4,
      src: course4,
      title: 'Курс 4'
    }
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container">
      <div className="slider-wrapper">
        {images.map((img, index) => (
          <div
            key={img.id}
            className={`slide ${index === currentIndex ? 'active' : ''}`}
          >
            <img src={img.src} alt={img.title} className="slide-image" />
            <div className="slide-overlay"></div>
          </div>
        ))}
      </div>
      <button className="slider-btn slider-btn-prev" onClick={goToPrevious}>
        <ChevronLeft className="slider-icon" size={24} />
      </button>
      <button className="slider-btn slider-btn-next" onClick={goToNext}>
        <ChevronRight className="slider-icon" size={24} />
      </button>
      <div className="slider-dots">
        {images.map((_, index) => (
          <button
            key={index}
            className={`dot ${index === currentIndex ? 'active' : ''}`}
            onClick={() => goToSlide(index)}
            aria-label={`Go to slide ${index + 1}`}
          />
        ))}
      </div>
    </div>
  )
}

export default ImageSlider
